﻿IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_fn_ApplyUtcOffset]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
	DROP FUNCTION [dbo].[VX_fn_ApplyUtcOffset]
GO

CREATE FUNCTION [dbo].[VX_fn_ApplyUtcOffset]
(
	@sourceDateTime datetime,
	@gmtbias float,
	@dstbias float,
	@stdmonth int,
	@stdday int,
	@dstmonth int,
	@dstday int,
	@dstactive bit
)
RETURNS datetime
AS
BEGIN
	DECLARE @newdt datetime

	IF (@sourceDateTime > 2)
	BEGIN
		DECLARE @stddate datetime
		DECLARE @dstdate datetime
		DECLARE @sourceDateYear int

		--Get the year of the source date
		SET @sourceDateYear = DATEPART(yyyy, @sourceDateTime)
		DECLARE @isSourceDateDst bit
		SET @isSourceDateDst = 0
  
		-- Determine which one comes first in the year Standard Time
		IF (@dstbias > 0)
		BEGIN
			--Get Standard Time Starting date
			SET @stddate = dbo.FGetSundayDate(@sourceDateYear, @stdmonth, @stdday)
			--Get Dst Time Starting date
			SET @dstdate = dbo.FGetSundayDate(@sourceDateYear, @dstmonth, @dstday)

			IF (@stddate > @dstdate)
			BEGIN
				IF (@sourceDateTime >= @dstdate AND  @sourceDateTime < @stdDate)
				BEGIN
					SET @isSourceDateDst = 1
				END
			END
			ELSE
			BEGIN
				IF (@sourceDateTime >= @stddate AND  @sourceDateTime < @dstDate)
				BEGIN
					SET @isSourceDateDst = 0
				END
				ELSE
				BEGIN
					SET @isSourceDateDst = 1
				END
			END
		END

		IF (@isSourceDateDst = 1)
		BEGIN
			SET @newdt = DATEADD(mi, @gmtbias * 60, @sourceDateTime)
			SET @newdt = DATEADD(mi, @dstbias * 60, @newdt)
		END
		ELSE
		BEGIN
			SET @newdt = DATEADD(mi, @gmtbias * 60, @sourceDateTime)
		END
	END
	ELSE
	BEGIN -- (@sourceDateTime =< 2), we do not convert these date, they are flag date
		SET @newdt = @sourceDateTime
	END

	-- Return the result of the function
	RETURN @newdt
END
GO